import Footer from "@/components/layout/Footer";
import SiteNotifications from "@/components/layout/SiteNotifications";
import { NotificationProvider } from "@/context/NotificationContext";
import Navbar from "@/components/layout/Header";

export const metadata = {
	title: "Geenrecept | Medicijnen Zonder Recept",
	description:
		"Bestel veilig zonder recept via iDEAL of Bancontact bij geenrecept.com.",
};

export default function MainLayout({ children }) {
	return (
		<>
			<NotificationProvider>
				<SiteNotifications />
				{/* Rest of your layout */}
				<Navbar />
				<main>{children}</main>
				<Footer />
			</NotificationProvider>
		</>
	);
}
