import Image from "next/image"
import Link from "next/link"

export default function AboutPage() {
  return (
    <div className="min-h-screen bg-white">
      {/* Hero sectie */}
      <div className="bg-gradient-to-r from-blue-600 to-purple-600 text-white py-12 px-4">
        <div className="max-w-7xl mx-auto">
          <h1 className="text-3xl md:text-4xl font-bold mb-4 !text-white">Over Geenrecept</h1>
          <p className="!text-white max-w-2xl">Leer meer over onze missie, visie en het team achter Geenrecept.</p>
        </div>
      </div>

      {/* Missie & Visie */}
      <section className="py-16 px-4">
        <div className="max-w-7xl mx-auto">
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold mb-6">Onze Missie & Visie</h2>
              <p className="text-gray-600 mb-6">
                Bij Geenrecept geloven we dat iedereen toegang moet hebben tot betaalbare en kwalitatieve medicijnen.
                Onze missie is om medicijnen toegankelijk te maken voor iedereen, zonder de noodzaak van een recept voor
                niet-voorschriftplichtige medicijnen.
              </p>
              <p className="text-gray-600 mb-6">
                We streven ernaar om de beste online apotheek te zijn, met een focus op klanttevredenheid,
                productkwaliteit en betrouwbaarheid. We werken samen met gerenommeerde fabrikanten om ervoor te zorgen
                dat onze klanten alleen de beste medicijnen ontvangen.
              </p>
              <div className="flex flex-col sm:flex-row gap-4">
                <Link href="/shop" className="btn-primary text-center !text-white">
                  Bekijk ons assortiment
                </Link>
                <Link href="/contact" className="btn-secondary text-center !text-white">
                  Neem contact op
                </Link>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Waarom kiezen voor Geenrecept */}
      <section className="py-16 px-4 bg-gray-50">
        <div className="max-w-7xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold mb-4">Waarom kiezen voor Geenrecept?</h2>
            <p className="text-gray-600 max-w-2xl mx-auto">
              We onderscheiden ons door onze toewijding aan kwaliteit, betrouwbaarheid en klanttevredenheid.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="bg-white rounded-xl shadow-md p-6 transition-transform duration-300 hover:transform hover:scale-105">
              <div className="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mb-6">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-8 w-8 text-blue-600"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"
                  />
                </svg>
              </div>
              <h3 className="text-xl font-semibold mb-3">Kwaliteitsgarantie</h3>
              <p className="text-gray-600">
                Alle medicijnen worden zorgvuldig geselecteerd en gecontroleerd op kwaliteit. We werken alleen met
                gerenommeerde fabrikanten en leveranciers.
              </p>
            </div>

            <div className="bg-white rounded-xl shadow-md p-6 transition-transform duration-300 hover:transform hover:scale-105">
              <div className="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mb-6">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-8 w-8 text-purple-600"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"
                  />
                </svg>
              </div>
              <h3 className="text-xl font-semibold mb-3">Snelle Levering</h3>
              <p className="text-gray-600">
                We begrijpen dat tijd kostbaar is, vooral als het gaat om medicijnen. Daarom bieden we snelle levering
                binnen 24 uur in heel Nederland.
              </p>
            </div>

            <div className="bg-white rounded-xl shadow-md p-6 transition-transform duration-300 hover:transform hover:scale-105">
              <div className="w-16 h-16 bg-cyan-100 rounded-full flex items-center justify-center mb-6">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-8 w-8 text-cyan-600"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z"
                  />
                </svg>
              </div>
              <h3 className="text-xl font-semibold mb-3">Deskundig Advies</h3>
              <p className="text-gray-600">
                Ons team van deskundige apothekers staat klaar om al je vragen te beantwoorden en advies te geven over
                het gebruik van medicijnen.
              </p>
            </div>
          </div>
        </div>
      </section>
      {/* CTA Sectie */}
      <section className="py-16 px-4 bg-gradient-to-r from-blue-600 to-purple-600 text-white">
        <div className="max-w-7xl mx-auto text-center">
          <h2 className="text-3xl font-bold mb-6 !text-white">Klaar om je medicijnen te bestellen?</h2>
          <p className="text-xl mb-8 max-w-3xl mx-auto !text-white">
            Bestel vandaag nog en ontvang je medicijnen morgen al bij je thuis.
          </p>
          <Link href="/shop" className="btn-primary bg-white text-blue-600 hover:bg-gray-100">
            Bekijk ons assortiment
          </Link>
        </div>
      </section>
    </div>
  )
}
