"use client";
import { Inter } from "next/font/google";
import "./globals.css";
import { CartProvider } from "@/context/CartContext";
import { AuthProvider } from "@/context/AuthContext";
import { Toaster } from "sonner";
import { NotificationProvider } from "@/context/NotificationContext";
import Script from "next/script";

const inter = Inter({ subsets: ["latin"] });

export default function RootLayout({ children }) {
	return (
		<html lang="nl">
			<body className={inter.className}>
				<Script
					src="https://www.googletagmanager.com/gtag/js?id=G-F77K67K3QC"
					strategy="afterInteractive"
				/>
				<Script id="google-analytics" strategy="afterInteractive">
					{`
						 window.dataLayer = window.dataLayer || [];
  						function gtag(){dataLayer.push(arguments);}
  						gtag('js', new Date());
  						gtag('config', 'G-F77K67K3QC');
					`}
				</Script>
				<AuthProvider>
					<CartProvider>
						<NotificationProvider>
							<div>
								<Toaster richColors position="top-right" />
								<div className="flex-grow">{children}</div>
							</div>
						</NotificationProvider>
					</CartProvider>
				</AuthProvider>
			</body>
		</html>
	);
}
