import { Truck, Clock, HeartHandshake, Euro, Shield, Star } from "lucide-react"

export default function Features() {
	const features = [
		{
			icon: <Truck className="h-6 w-6" />,
			title: "Snelle & Anonieme verzending",
			description: "Discrete levering binnen 1-2 werkdagen",
			gradient: "from-[#1eaaff] to-[#0071e6]",
		},
		{
			icon: <Euro className="h-6 w-6" />,
			title: "Beste prijs/kwaliteit",
			description: "Hoogwaardige producten voor een eerlijke prijs",
			gradient: "from-[#00e889] to-[#00985a]",
		},
		{
			icon: <Clock className="h-6 w-6" />,
			title: "Voor 16:00 besteld, direct verzonden",
			description: "Snelle verwerking van je bestelling",
			gradient: "from-[#8a4fff] to-[#5a18d3]",
		},
		{
			icon: <HeartHandshake className="h-6 w-6" />,
			title: "Uitstekende klantenservice",
			description: "Persoonlijke ondersteuning bij al je vragen",
			gradient: "from-[#ff6b6b] to-[#ee5253]",
		},
		{
			icon: <Shield className="h-6 w-6" />,
			title: "100% Veilig & Betrouwbaar",
			description: "Gegarandeerde kwaliteit en veilige betaling",
			gradient: "from-[#feca57] to-[#ff9f43]",
		},
		{
			icon: <Star className="h-6 w-6" />,
			title: "Hoogste kwaliteit medicijnen",
			description: "Alleen de beste producten in ons assortiment",
			gradient: "from-[#54a0ff] to-[#2e86de]",
		},
	]

	return (
		<section className="py-20 relative overflow-hidden">
			{/* Background elements */}
			<div className="absolute inset-0 bg-gradient-to-br from-white via-[#f8f9ff] to-white -z-10"></div>
			<div className="absolute inset-0 bg-[url('/grid-pattern.png')] bg-repeat opacity-[0.03] -z-10"></div>

			{/* Decorative elements */}
			<div className="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-transparent via-[#1eaaff]/30 to-transparent"></div>
			<div className="absolute bottom-0 left-0 w-full h-1 bg-gradient-to-r from-transparent via-[#8a4fff]/30 to-transparent"></div>

			<div className="container mx-auto px-4">
				<div className="text-center mb-16 max-w-3xl mx-auto">
					<div className="inline-flex items-center px-4 py-2 bg-white rounded-full shadow-md mb-4">
						<span className="h-2 w-2 rounded-full bg-[#8a4fff] mr-2 animate-pulse-slow"></span>
						<span className="text-sm font-medium bg-clip-text text-transparent bg-gradient-to-r from-[#1eaaff] to-[#8a4fff]">
							Waarom kiezen voor Geenrecept?
						</span>
					</div>

					<h2 className="text-3xl md:text-4xl font-bold mb-6">
						Ontdek de voordelen van onze <span className="text-[#1eaaff]">online apotheek</span>
					</h2>

					<p className="text-gray-600">
						Bij Geenrecept streven we naar de hoogste kwaliteit en service. Onze klanten waarderen onze snelle levering,
						discrete verpakking en uitstekende klantenservice.
					</p>
				</div>

				<div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
					{features.map((feature, index) => (
						<div key={index} className="group relative overflow-hidden" style={{ animationDelay: `${index * 0.1}s` }}>
							{/* Card with hover effect */}
							<div className="relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-xl transition-all duration-500 z-10 h-full border border-gray-100 hover:border-[#1eaaff]/30">
								{/* Icon with gradient background */}
								<div className={`mb-6 relative`}>
									{/* <div
										className={`absolute inset-0 bg-gradient-to-br ${feature.gradient} rounded-xl opacity-10 group-hover:opacity-20 transition-opacity duration-300`}
									></div> */}
									<div
										className={`relative w-14 h-14 flex items-center justify-center rounded-xl bg-gradient-to-br ${feature.gradient} text-white transform group-hover:scale-110 transition-transform duration-300`}
									>
										{feature.icon}
									</div>
								</div>

								{/* Content */}
								<h3 className="text-xl font-semibold mb-3 text-gray-900 group-hover:text-[#1eaaff] transition-colors duration-300">
									{feature.title}
								</h3>

								<p className="text-gray-600">{feature.description}</p>

								{/* Decorative corner */}
								<div className="absolute top-0 right-0 w-0 h-0 border-t-[40px] border-r-[40px] border-t-transparent border-r-white opacity-50"></div>
							</div>

							{/* Background gradient on hover */}
							<div
								className={`absolute inset-0 bg-gradient-to-br ${feature.gradient} opacity-0 group-hover:opacity-5 transition-opacity duration-500 rounded-2xl`}
							></div>
						</div>
					))}
				</div>
			</div>
		</section>
	)
}
