import Link from "next/link"
import { ArrowRight, CheckCircle } from "lucide-react"

export default function Hero() {
  return (
    <section className="relative overflow-hidden py-20 lg:py-28">
      {/* Background with abstract shapes */}
      <div className="absolute inset-0 -z-10">
        <div className="absolute top-0 right-0 w-full h-full bg-gradient-to-bl from-[#edfaff] via-white to-[#f5f3ff]"></div>

        {/* Animated circles */}
        <div
          className="absolute top-20 left-[10%] w-72 h-72 rounded-full bg-[#1eaaff]/5 animate-float"
          style={{ animationDelay: "0s" }}
        ></div>
        <div
          className="absolute bottom-40 right-[5%] w-96 h-96 rounded-full bg-[#8a4fff]/5 animate-float"
          style={{ animationDelay: "1s" }}
        ></div>
        <div
          className="absolute top-[30%] right-[20%] w-48 h-48 rounded-full bg-[#00e889]/5 animate-float"
          style={{ animationDelay: "2s" }}
        ></div>

        {/* Grid pattern overlay */}
        <div className="absolute inset-0 bg-[url('/grid-pattern.png')] bg-repeat opacity-[0.03]"></div>

        {/* Decorative elements */}
        <div className="absolute top-20 left-[20%] w-20 h-1 bg-gradient-to-r from-[#1eaaff] to-transparent rounded-full"></div>
        <div className="absolute top-40 right-[30%] w-1 h-20 bg-gradient-to-b from-[#8a4fff] to-transparent rounded-full"></div>
        <div className="absolute bottom-20 left-[40%] w-1 h-20 bg-gradient-to-b from-[#00e889] to-transparent rounded-full"></div>
        <div className="absolute bottom-40 right-[10%] w-20 h-1 bg-gradient-to-r from-[#1eaaff] to-transparent rounded-full"></div>
      </div>

      <div className="container mx-auto px-4 max-w-7xl">
        <div className="flex flex-col lg:flex-row items-center gap-16">
          {/* Left content */}
          <div className="w-full lg:w-1/2 space-y-8 z-10">
            <div className="inline-flex items-center px-4 py-2 bg-white rounded-full shadow-md animate-fade-in">
              <span className="h-2 w-2 rounded-full bg-[#00e889] mr-2 animate-pulse-slow"></span>
              <span className="text-sm font-medium bg-clip-text text-transparent bg-gradient-to-r from-[#1eaaff] to-[#8a4fff]">
                100% Discrete Verzending
              </span>
            </div>

            <h1 className="text-5xl lg:text-6xl font-bold leading-tight animate-fade-in">
              <span className="relative">
                <span className="bg-clip-text text-transparent bg-gradient-to-r from-[#1eaaff] to-[#00e889]">
                  Geenrecept
                </span>
                <span className="absolute -bottom-2 left-0 w-full h-1 bg-gradient-to-r from-[#8a4fff] to-[#1eaaff] rounded-full"></span>
              </span>
              <br />
              <span className="text-gray-800">Jouw online apotheek</span>
            </h1>

            <p className="text-lg text-gray-600 max-w-xl animate-fade-in" style={{ animationDelay: "0.2s" }}>
              Wij bieden een veilige en betrouwbare manier om medicijnen te bestellen zonder recept. Met snelle
              levering, discrete verpakking en 24/7 klantenservice.
            </p>

            <div className="space-y-4 animate-fade-in" style={{ animationDelay: "0.3s" }}>
              <div className="flex items-center gap-3">
                <CheckCircle className="h-5 w-5 text-[#00e889]" />
                <span className="text-gray-700">Snelle levering binnen 1-2 werkdagen</span>
              </div>
              <div className="flex items-center gap-3">
                <CheckCircle className="h-5 w-5 text-[#00e889]" />
                <span className="text-gray-700">100% anonieme en discrete verpakking</span>
              </div>
              <div className="flex items-center gap-3">
                <CheckCircle className="h-5 w-5 text-[#00e889]" />
                <span className="text-gray-700">Veilige betaling via iDEAL of Bancontact</span>
              </div>
            </div>

            <div className="flex flex-col sm:flex-row gap-4 pt-4 animate-fade-in" style={{ animationDelay: "0.4s" }}>
              <Link href="/shop" className="group">
                <div className="relative overflow-hidden bg-gradient-to-r from-[#8a4fff] to-[#1eaaff] text-white font-medium py-4 px-8 rounded-xl flex items-center justify-center transition-all duration-300 shadow-lg hover:shadow-xl">
                  <span className="relative z-10">Bekijk ons assortiment</span>
                  <ArrowRight
                    size={18}
                    className="ml-2 relative z-10 transform group-hover:translate-x-1 transition-transform duration-300"
                  />

                  {/* Animated background */}
                  <div className="absolute top-0 left-0 w-full h-full bg-gradient-to-r from-[#7c2dff] to-[#0a8aff] opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                </div>
              </Link>

              <Link href="/over-ons">
                <div className="relative overflow-hidden bg-white text-gray-800 border border-gray-200 font-medium py-4 px-8 rounded-xl flex items-center justify-center transition-all duration-300 shadow-md hover:shadow-lg group">
                  <span className="relative z-10">Meer informatie</span>

                  {/* Hover effect */}
                  <div className="absolute top-0 left-0 w-0 h-full bg-gray-50 group-hover:w-full transition-all duration-300 ease-out"></div>
                </div>
              </Link>
            </div>
          </div>

          {/* Right content - 3D medicine visualization */}
          <div className="w-full lg:w-1/2 relative z-10 sm:block hidden">
            <div className="relative">
              {/* Main image container with glass effect */}
              <div className="relative bg-white/30 backdrop-blur-sm p-8 rounded-2xl shadow-xl border border-white/50 overflow-hidden">
                {/* Background glow effects */}
                <div className="absolute -top-20 -right-20 w-40 h-40 rounded-full bg-[#1eaaff]/20 blur-3xl"></div>
                <div className="absolute -bottom-20 -left-20 w-40 h-40 rounded-full bg-[#8a4fff]/20 blur-3xl"></div>

                {/* Main product image */}
                <div className="relative h-[400px] w-full animate-float">
                  <img
                    src="https://aurobindo.nl/wp-content/uploads/2021/07/potje-met-pillen-324x243.jpg"
                    alt="Medicijnen assortiment"
                    fill
                    className="object-contain"
                    priority
                  />
                </div>

                {/* Floating pill elements */}
                <div
                  className="absolute top-[15%] left-[10%] w-16 h-16 animate-float"
                  style={{ animationDelay: "1.5s" }}
                >
                  <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQAaxnYDkrcgxiiztyhQVgmM8lfw-b0yVAUW9JbfkYiprSF-KOVDSJveGH8UGR3MD_1nBM&usqp=CAU" alt="Medicijn" width={64} height={64} className="object-contain" />
                </div>

                <div
                  className="absolute bottom-[20%] right-[15%] w-20 h-20 animate-float"
                  style={{ animationDelay: "2s" }}
                >
                  <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcREA_gb4lFQMJ-B4CjGMCn7oqvtOD8p0vXNpA&s" alt="Medicijn" width={80} height={80} className="object-contain" />
                </div>

                {/* Product info cards */}
                <div
                  className="absolute top-[10%] right-[5%] bg-white p-3 rounded-lg shadow-lg animate-fade-in"
                  style={{ animationDelay: "0.6s" }}
                >
                  <div className="flex items-center gap-2">
                    <div className="h-8 w-8 rounded-full bg-[#1eaaff]/10 flex items-center justify-center">
                      <span className="text-[#1eaaff] font-bold text-sm">24h</span>
                    </div>
                    <span className="text-sm font-medium">Snelle levering</span>
                  </div>
                </div>

                <div
                  className="absolute bottom-[10%] left-[5%] bg-white p-3 rounded-lg shadow-lg animate-fade-in"
                  style={{ animationDelay: "0.8s" }}
                >
                  <div className="flex items-center gap-2">
                    <div className="h-8 w-8 rounded-full bg-[#00e889]/10 flex items-center justify-center">
                      <span className="text-[#00e889] font-bold text-sm">100%</span>
                    </div>
                    <span className="text-sm font-medium">Kwaliteit</span>
                  </div>
                </div>
              </div>

              {/* Decorative elements */}
              <div className="absolute -top-4 -right-4 w-8 h-8 bg-[#1eaaff] rounded-full animate-pulse-slow"></div>
              <div
                className="absolute -bottom-4 -left-4 w-8 h-8 bg-[#00e889] rounded-full animate-pulse-slow"
                style={{ animationDelay: "1.5s" }}
              ></div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
