const NewsLetter = () => {
  return (
    <section className="py-20 bg-white">
      <div className="container mx-auto px-4">
        <div className="max-w-5xl mx-auto bg-gradient-to-r from-purple-600 to-violet-700 rounded-xl shadow-2xl overflow-hidden">
          <div className="grid md:grid-cols-2">
            <div className="p-10 md:p-12">
              <h2 className="text-3xl font-bold text-white mb-4">Blijf op de hoogte</h2>
              <p className="text-purple-100 mb-8">Schrijf je in voor onze nieuwsbrief en ontvang:</p>
              <ul className="space-y-4 mb-8">
                <li className="flex items-start">
                  <svg
                    className="w-5 h-5 text-purple-300 mr-3 mt-0.5"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                  </svg>
                  <span className="text-white">Exclusieve aanbiedingen</span>
                </li>
                <li className="flex items-start">
                  <svg
                    className="w-5 h-5 text-purple-300 mr-3 mt-0.5"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                  </svg>
                  <span className="text-white">Nieuwe productinformatie</span>
                </li>
                <li className="flex items-start">
                  <svg
                    className="w-5 h-5 text-purple-300 mr-3 mt-0.5"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                  </svg>
                  <span className="text-white">Gezondheidsadvies en tips</span>
                </li>
                <li className="flex items-start">
                  <svg
                    className="w-5 h-5 text-purple-300 mr-3 mt-0.5"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                  </svg>
                  <span className="text-white">10% korting op je eerste bestelling</span>
                </li>
              </ul>
              <div className="bg-white/20 backdrop-blur-sm rounded-lg p-4 text-white text-sm">
                <p>
                  <svg
                    className="w-5 h-5 inline-block mr-2 text-purple-300"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      strokeWidth={2}
                      d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
                    />
                  </svg>
                  We sturen je alleen relevante informatie, geen spam. Je kunt je op elk moment uitschrijven.
                </p>
              </div>
            </div>
            <div className="p-10 md:p-12 bg-white">
              <h3 className="text-2xl font-bold text-gray-900 mb-6">Schrijf je nu in</h3>
              <form className="space-y-4">
                <div>
                  <label htmlFor="name" className="block text-sm font-medium text-gray-700 mb-1">
                    Naam
                  </label>
                  <input
                    type="text"
                    id="name"
                    name="name"
                    className="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent"
                    placeholder="Uw naam"
                  />
                </div>
                <div>
                  <label htmlFor="email" className="block text-sm font-medium text-gray-700 mb-1">
                    E-mailadres
                  </label>
                  <input
                    type="email"
                    id="email"
                    name="email"
                    className="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent"
                    placeholder="uw@email.nl"
                    required
                  />
                </div>
                <button
                  type="submit"
                  className="w-full bg-gradient-to-r from-purple-600 to-violet-700 hover:from-purple-700 hover:to-violet-800 text-white font-medium py-3 px-4 rounded-lg transition-colors shadow-lg"
                >
                  Inschrijven
                </button>
                <p className="text-xs text-gray-500 text-center mt-4">
                  Door je in te schrijven ga je akkoord met ons{" "}
                  <a href="#" className="underline hover:text-purple-600">
                    privacybeleid
                  </a>
                </p>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}

export default NewsLetter
