"use client";

import React, { useEffect } from "react";

const TrustPilotWidget = () => {
  useEffect(() => {
    const script = document.createElement("script");
    script.src =
      "https://widget.trustpilot.com/bootstrap/v5/tp.widget.bootstrap.min.js";
    script.async = true;
    document.body.appendChild(script);
  }, []);

  return (
    <div className="w-full flex justify-center items-center h-10 mt-20 py-4">
      <div
        className="trustpilot-widget"
        data-locale="nl"
        data-template-id={process.env.NEXT_PUBLIC_TEMPLETE_ID}
        data-businessunit-id={process.env.NEXT_PUBLIC_UNIT_ID}
        data-style-height="150px"
        data-style-width="100%"
        data-theme="light">
        <a
          href="https://www.trustpilot.com/review/your-business-url"
          target="_blank"
          rel="noopener noreferrer">
          Trustpilot Reviews
        </a>
      </div>
    </div>
  );
};

export default TrustPilotWidget;
