import { Clock, CheckCircle, Truck, Package, CreditCard } from "lucide-react"

export function OrderStatusTimeline({ order }) {
  if (!order) return null

  const getStatusStep = (status) => {
    switch (status) {
      case "processing":
        return 1
      case "shipped":
        return 2
      case "delivered":
        return 3
      default:
        return 0
    }
  }

  const getPaymentStatusStep = (paymentStatus) => {
    switch (paymentStatus) {
      case "pending":
        return 0
      case "paid":
        return 1
      case "failed":
        return -1
      default:
        return 0
    }
  }

  const currentStep = getStatusStep(order.status)
  const paymentStep = getPaymentStatusStep(order.paymentStatus)

  return (
    <div className="bg-white rounded-lg shadow p-6">
      <h2 className="text-lg font-bold mb-6">Bestelstatus</h2>

      <div className="relative">
        {/* Timeline line */}
        <div className="absolute left-6 top-0 bottom-0 w-0.5 bg-gray-200"></div>

        {/* Payment Status */}
        <div className="relative flex items-start mb-8">
          <div
            className={`h-12 w-12 rounded-full flex items-center justify-center z-10 ${paymentStep === 1
                ? "bg-green-100 text-green-600"
                : paymentStep === -1
                  ? "bg-red-100 text-red-600"
                  : "bg-yellow-100 text-yellow-600"
              }`}
          >
            <CreditCard size={24} />
          </div>
          <div className="ml-6">
            <h3 className="text-lg font-medium">
              {paymentStep === 1
                ? "Betaling ontvangen"
                : paymentStep === -1
                  ? "Betaling mislukt"
                  : "Wachtend op betaling"}
            </h3>
            <p className="text-gray-600 mt-1">
              {paymentStep === 1
                ? "Je betaling is succesvol verwerkt."
                : paymentStep === -1
                  ? "Er is een probleem opgetreden met je betaling. Neem contact op met de klantenservice."
                  : "We wachten op de bevestiging van je betaling."}
            </p>
            {order.paymentMethod && <p className="text-sm text-gray-500 mt-1">Betaalmethode: {order.paymentMethod}</p>}
          </div>
        </div>

        {/* Order Processing */}
        <div className="relative flex items-start mb-8">
          <div
            className={`h-12 w-12 rounded-full flex items-center justify-center z-10 ${currentStep >= 1 ? "bg-green-100 text-green-600" : "bg-gray-100 text-gray-400"
              }`}
          >
            <Clock size={24} />
          </div>
          <div className="ml-6">
            <h3 className="text-lg font-medium">Bestelling in behandeling</h3>
            <p className="text-gray-600 mt-1">
              {currentStep >= 1
                ? "Je bestelling wordt verwerkt en voorbereid voor verzending."
                : "Je bestelling is nog niet in behandeling genomen."}
            </p>
            {currentStep === 1 && (
              <div className="mt-2 text-sm text-yellow-600 bg-yellow-50 px-3 py-1 rounded-full inline-flex items-center">
                <Clock size={14} className="mr-1" />
                Huidige status
              </div>
            )}
          </div>
        </div>

        {/* Order Shipped */}
        <div className="relative flex items-start mb-8">
          <div
            className={`h-12 w-12 rounded-full flex items-center justify-center z-10 ${currentStep >= 2 ? "bg-green-100 text-green-600" : "bg-gray-100 text-gray-400"
              }`}
          >
            <Package size={24} />
          </div>
          <div className="ml-6">
            <h3 className="text-lg font-medium">Bestelling verzonden</h3>
            <p className="text-gray-600 mt-1">
              {currentStep >= 2
                ? "Je bestelling is verzonden en onderweg naar je afleveradres."
                : "Je bestelling is nog niet verzonden."}
            </p>
            {currentStep === 2 && (
              <div className="mt-2 text-sm text-blue-600 bg-blue-50 px-3 py-1 rounded-full inline-flex items-center">
                <Truck size={14} className="mr-1" />
                Huidige status
              </div>
            )}
          </div>
        </div>

        {/* Order Delivered */}
        <div className="relative flex items-start">
          <div
            className={`h-12 w-12 rounded-full flex items-center justify-center z-10 ${currentStep >= 3 ? "bg-green-100 text-green-600" : "bg-gray-100 text-gray-400"
              }`}
          >
            <CheckCircle size={24} />
          </div>
          <div className="ml-6">
            <h3 className="text-lg font-medium">Bestelling afgeleverd</h3>
            <p className="text-gray-600 mt-1">
              {currentStep >= 3
                ? "Je bestelling is afgeleverd op het opgegeven adres."
                : "Je bestelling is nog niet afgeleverd."}
            </p>
            {currentStep === 3 && (
              <div className="mt-2 text-sm text-green-600 bg-green-50 px-3 py-1 rounded-full inline-flex items-center">
                <CheckCircle size={14} className="mr-1" />
                Huidige status
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
  )
}
