import Link from "next/link"
import { products } from "@/lib/products"
import { Facebook, Instagram, Twitter, Mail, Phone, MapPin } from "lucide-react"

export default function Footer() {
  const Products = products?.map((i) => ({
    id: i.id,
    name: i.name,
    slug: i.slug,
  }))

  return (
    <footer className="bg-gradient-to-br from-[#0a2e5a] to-[#051a36] pt-16 pb-8 text-white text-sm relative overflow-hidden">
      {/* Background elements */}
      <div className="absolute top-0 left-0 w-full h-full overflow-hidden opacity-10 pointer-events-none">
        <div className="absolute top-10 left-10 w-40 h-40 rounded-full bg-[#1eaaff] blur-[100px]"></div>
        <div className="absolute bottom-10 right-10 w-60 h-60 rounded-full bg-[#00e889] blur-[120px]"></div>
        <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 rounded-full bg-[#7c2dff] blur-[150px]"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div className="grid grid-cols-1 md:grid-cols-5 gap-10">
          <div className="col-span-1 md:col-span-1">
            <Link href={"/"}>
              <span className="text-3xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-[#1eaaff] to-[#00e889]">
                Geenrecept
              </span>
            </Link>
            <p className="mt-4 text-gray-300">Betrouwbare online apotheek voor al uw medicijnen zonder recept.</p>

          </div>

          <div className="col-span-1">
            <h3 className="font-bold text-lg mb-4 text-[#1eaaff]">Navigatie</h3>
            <ul className="space-y-3">
              <li>
                <Link
                  href="/shop"
                  className="text-gray-300 hover:text-[#1eaaff] transition-colors duration-300 flex items-center"
                >
                  <span className="mr-2 text-[#1eaaff]">›</span> Medicijnen
                </Link>
              </li>

              <li>
                <Link
                  href="/over-ons"
                  className="text-gray-300 hover:text-[#1eaaff] transition-colors duration-300 flex items-center"
                >
                  <span className="mr-2 text-[#1eaaff]">›</span> Over ons
                </Link>
              </li>
              <li>
                <Link
                  href="/blog"
                  className="text-gray-300 hover:text-[#1eaaff] transition-colors duration-300 flex items-center"
                >
                  <span className="mr-2 text-[#1eaaff]">›</span> Blog
                </Link>
              </li>
              <li>
                <Link
                  href="/dashboard"
                  className="text-gray-300 hover:text-[#1eaaff] transition-colors duration-300 flex items-center"
                >
                  <span className="mr-2 text-[#1eaaff]">›</span> Mijn account
                </Link>
              </li>
              <li>
                <Link
                  href="/register"
                  className="text-gray-300 hover:text-[#1eaaff] transition-colors duration-300 flex items-center"
                >
                  <span className="mr-2 text-[#1eaaff]">›</span> Aanmelden
                </Link>
              </li>
            </ul>
          </div>

          <div className="md:col-span-2">
            <h3 className="font-bold text-lg mb-4 text-[#1eaaff]">Populaire Producten</h3>
            <div className="grid grid-cols-1 sm:grid-cols-2 gap-3">
              {Products.slice(0, 10).map((product, index) => (
                <Link
                  key={index}
                  href={`/product/${product.slug.toLowerCase().split(" ").join("-")}`}
                  className="text-gray-300 hover:text-[#1eaaff] transition-colors duration-300 flex items-center"
                >
                  <span className="mr-2 text-[#1eaaff]">›</span> {product.name.replace(/tabletten/i, "").trim()}
                </Link>
              ))}
            </div>
          </div>

          <div className="col-span-1">
            <h3 className="font-bold text-lg mb-4 text-[#1eaaff]">Contact</h3>
            <ul className="space-y-4">
              <li className="flex items-start">
                <Mail size={18} className="mr-3 text-[#1eaaff] mt-1" />
                <span className="text-gray-300">info@geenrecept.com</span>
              </li>

              <li className="flex items-start">
                <MapPin size={18} className="mr-3 text-[#1eaaff] mt-1" />
                <span className="text-gray-300">Nederland</span>
              </li>
              <li className="mt-6">
                <Link
                  href="/contact"
                  className="inline-block px-5 py-2 bg-[#1eaaff] text-white rounded-full hover:bg-[#0a8aff] transition-colors duration-300"
                >
                  Contact opnemen
                </Link>
              </li>
            </ul>
          </div>
        </div>

        <div className="border-t border-gray-800 mt-12 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center">
            <p className="text-gray-400 text-sm">© Geenrecept {new Date().getFullYear()}. Alle rechten voorbehouden.</p>
            <div className="flex space-x-4 mt-4 md:mt-0">
              <img src="/payment-ideal.png" alt="iDEAL" className="h-8 w-auto" />
              <img src="/payment-bancontact.png" alt="Bancontact" className="h-8 w-auto" />
            </div>
          </div>
        </div>
      </div>
    </footer>
  )
}
